import { world, system, ItemStack, BlockPermutation } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('v360:trophy_water', {
        onConsume({ source }) {
            if (source.hasComponent('minecraft:onfire')) {
                source.extinguishFire(true)
                source.dimension.playSound('random.fizz', player.location)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('v360:trophy_milk', {
        onConsume({ source }) {
            source.runCommand(`effect @s clear`)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.itemComponentRegistry.registerCustomComponent('v360:trophy_honey', {
        onConsume({ source }) {
            source.removeEffect('poison')
        }
    })
})

world.afterEvents.playerInteractWithEntity.subscribe(data => {
    const player = data.player
    const target = data.target
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const milkTrophy = selectedItem.typeId.split(':')[1]
    if (target.typeId === 'minecraft:cow' && selectedItem?.typeId.includes('trophy')) {
        if (player.getGameMode() !== 'creative') {
            player.runCommand(`clear @s v360:${milkTrophy} 0 1`)
        }
        player.dimension.playSound('mob.cow.milk', player.location)
        system.run(() => {
            if (player.getComponent('inventory').container.emptySlotsCount === 0) {
                player.dimension.spawnItem(new ItemStack(`v360:${milkTrophy}_milk`), player.location)
            }
            else player.getComponent('inventory').container.addItem(new ItemStack(`v360:${milkTrophy}_milk`))
        })
    }
})

world.afterEvents.playerInteractWithBlock.subscribe(data => {
    const player = data.player
    const block = data.block
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const waterTrophy = selectedItem?.typeId.split(':')[1]
    if (block.typeId.includes('water') && selectedItem?.typeId.includes('trophy')) {
        if (player.getGameMode() !== 'creative') {
            player.runCommand(`clear @s v360:${waterTrophy} 0 1`)
        }
        player.dimension.playSound('mob.cow.milk', player.location)
        system.run(() => {
            if (player.getComponent('inventory').container.emptySlotsCount === 0) {
                player.dimension.spawnItem(new ItemStack(`v360:${waterTrophy}_water`), player.location)
            }
            else player.getComponent('inventory').container.addItem(new ItemStack(`v360:${waterTrophy}_water`))
        })
    }
})

function getBlockPlacedOnto(block, face) {
    switch (face) {
        case 'Up': return block.below();
        case 'Down': return block.above();
        case 'North': return block.south();
        case 'South': return block.north();
        case 'East': return block.west();
        case 'Wesr': return block.east();
    }
}

world.beforeEvents.worldInitialize.subscribe((data) => {
    data.blockTypeRegistry.registerCustomComponent('v360:trophy_item', {
        beforeOnPlayerPlace(event) {
            const { block, face } = event;
            event.cancel = getBlockPlacedOnto(block, face).typeId === 'minecraft:bee_nest'
        }
    })
})